function deepMerge(target, source) {
  var newObj = JSON.parse(JSON.stringify(target));
  Object.keys(source).forEach(function (key) {
    if (Array.isArray(source[key])) {
      if (!target[key]) {
        newObj[key] = source[key];
      } else if (Array.isArray(target[key])) {
        newObj[key] = (0, _to_consumable_array._)(target[key]).concat((0, _to_consumable_array._)(source[key]));
      } else {
        newObj[key] = source[key];
      }
    } else if (source[key] && typeof source[key] === "object") {
      if (!target[key] || typeof target[key] !== "object" || Array.isArray(target[key])) {
        newObj[key] = source[key];
      } else {
        newObj[key] = deepMerge(target[key], source[key]);
      }
    } else {
      newObj[key] = source[key];
    }
  });
  return newObj;
}
function ahe_js_function_0(data, newState) {
  let result = deepMerge(data, {
    fields: {
      _expand: newState
    }
  });
  if (typeof userTrack != 'undefined') {
    // 版本 < 8.106.0 才有这个对象
    userTrack.aheUT({
      eventType: '2101',
      pageName: 'AEShippingTracking',
      eventName: 'logistic_info_view_more_clk',
      params: {
        'spm-cnt': 'a1z65.aeshippingtracking.trackDetail'
      }
    });
    ahe.call('shippingTrackingAHEModule', 'trackingListChange', result);
    template.aheSetData(result);
  } else {
    // 版本 >= 8.106
    aheHandler.call('native', 'aeUT', ['2101', 'AEShippingTracking', 'logistic_info_view_more_clk', {
      'spm-cnt': 'a1z65.aeshippingtracking.trackDetail'
    }]);
    ahe.call('shippingTrackingAHEModule', 'trackingListChange', result);
  }
}