CREATE TABLE NOTEBOOKENTRY (
    PK INTEGER PRIMARY KEY,
    PROBLEM VARCHAR NOT NULL,
    SYMBOLABQUESTION VARCHAR,
    DISPLAY VARCHAR,
    SAVEDFROM VARCHAR NOT NULL,
    TOPIC VARCHAR,
    ISFAVORITE INTEGER,
    LASTCACHED TIMESTAMP,
    LASTCHANGE TIMESTAMP NOT NULL,
    REMOTEID VARCHAR NOT NULL UNIQUE,
    GRAPH VARCHAR,
    NOTES VARCHAR,
    URL VARCHAR
);

CREATE INDEX NOTEBOOKENTRY_PROBLEM_INDEX ON NOTEBOOKENTRY (PROBLEM);
CREATE INDEX NOTEBOOKENTRY_SYMBOLABQUESTION_INDEX ON NOTEBOOKENTRY (SYMBOLABQUESTION);
CREATE INDEX NOTEBOOKENTRY_DISPLAY_INDEX ON NOTEBOOKENTRY (DISPLAY);
CREATE INDEX NOTEBOOKENTRY_SAVEDFROM_INDEX ON NOTEBOOKENTRY (SAVEDFROM);
CREATE INDEX NOTEBOOKENTRY_TOPIC_INDEX ON NOTEBOOKENTRY (TOPIC);
CREATE INDEX NOTEBOOKENTRY_ISFAVORITE_INDEX ON NOTEBOOKENTRY (ISFAVORITE);
CREATE INDEX NOTEBOOKENTRY_LASTCHANGE_INDEX ON NOTEBOOKENTRY (LASTCHANGE);
CREATE INDEX NOTEBOOKENTRY_REMOTEID_INDEX ON NOTEBOOKENTRY (REMOTEID);
CREATE INDEX NOTEBOOKENTRY_ISFAVORITE_LASTCHANGE ON NOTEBOOKENTRY (ISFAVORITE, LASTCHANGE);
CREATE INDEX NOTEBOOKENTRY_REMOTEID ON NOTEBOOKENTRY (REMOTEID);

CREATE TABLE NOTEBOOKENTRY_TAGS (
    PK INTEGER PRIMARY KEY,
    NOTEBOOKENTRY_REMOTEID VARCHAR NOT NULL,
    TAG_TEXT VARCHAR NOT NULL,
    FOREIGN KEY (NOTEBOOKENTRY_REMOTEID) REFERENCES NOTEBOOKENTRY(REMOTEID)
);

CREATE INDEX NOTEBOOKENTRY_TAGS_ENTRY_REMOTE_ID ON NOTEBOOKENTRY_TAGS ( NOTEBOOKENTRY_REMOTEID );
CREATE INDEX NOTEBOOKENTRY_TAGS_TAG_TEXT ON NOTEBOOKENTRY_TAGS ( TAG_TEXT );
